<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <title>Nestor - Especialista Web</title>
  
  <?php require_once 'files/gtm_head.php'; ?>
  
  
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;700;900&display=swap" rel="stylesheet">
  
  <style>
    body {
      font-family: 'Barlow', Arial, sans-serif;
      background: #ece5dd;
      margin: 0;
      padding-bottom: 60px; 
    }
    .header {
      background: #075e54;
      color: white;
      padding: 10px;
      display: flex;
      align-items: center;
      position: sticky;
      top: 0;
      z-index: 10;
    }
    .header img {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      margin-right: 10px;
    }
    .status {
      font-size: 12px;
      color: #cfc;
      display: flex;
      align-items: center;
      gap: 5px;
    }
    .status::before {
      content: '';
      width: 8px;
      height: 8px;
      background: #4CAF50;
      border-radius: 50%;
    }
    .chat-container {
      padding-bottom: 50px;
    }
    .chat {
      background: #dcf8c6;
      border-radius: 7px;
      margin: 10px;
      padding: 10px;
      max-width: 90%;
      word-wrap: break-word;
    }
    
    #typing-indicator {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background-color: #f0f0f0;
      padding: 15px;
      box-sizing: border-box;
      border-top: 1px solid #ddd;
      display: none;
    }
    .writing-text {
      font-style: italic;
      color: #999;
      margin: 0;
    }

    .button-box {
      margin: 20px 10px;
    }
    .button {
      display: block;
      width: calc(100% - 20px);
      margin: 10px auto;
      padding: 12px 20px;
      font-size: 16px;
      font-weight: bold;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      text-decoration: none;
      text-align: center;
    }
    .sales-page {
      background: #07162d;
      color: white;
    }
    .last-chance {
        background-color: #ffc857;
        color: #07162d;
    }
    .facebook {
      background: #e0e0e0;
      color: #333;
    }
    .summary-container {
        margin: 10px;
    }
    .summary-card {
        background-color: #fff;
        border-radius: 7px;
        padding: 10px;
        border: 2px solid #075e54;
        text-align: center;
    }
    .summary-card-clickable {
        cursor: pointer;
    }
    .summary-card h3 {
        font-size: 18px;
        color: #07162d;
        margin: 5px 0 10px;
        font-weight: 900;
        text-transform: uppercase;
    }
    .summary-card img {
        width: 100%;
        max-width: 400px;
        border-radius: 5px;
    }
    .summary-card ul {
        list-style: none;
        padding: 0;
        margin: 10px 0;
        text-align: left;
    }
    .summary-card li {
        margin-bottom: 5px;
    }
    .summary-card .value {
        margin-top: 15px;
        font-weight: 700;
    }
    .summary-card .value span {
        text-decoration: line-through;
        color: #9e1428;
    }
    .summary-card .cta-text {
        background-color: #075e54;
        color: white;
        padding: 10px 20px;
        border-radius: 5px;
        display: inline-block;
        margin-top: 15px;
        font-weight: 900;
        text-decoration: none;
        cursor: pointer;
    }
  </style>
</head>
<body>

<?php require_once 'files/gtm_body.php'; ?>


<div class="header">
  <img src="img/perfil.webp" alt="Nestor" />
  <div>
    <strong>Nestor Orozco | Genera Más Clientes</strong><br />
    <span class="status">en línea</span>
  </div>
</div>

<div id="chatbox" class="chat-container"></div>

<div id="typing-indicator">
    <p class="writing-text">Escribiendo...</p>
</div>

<script>
    const chatbox = document.getElementById("chatbox");
    const typingIndicator = document.getElementById("typing-indicator");
    const salesPageUrl = "https://generamasclientes.com/oferta-web/oferta-especial.php#payment-section"; // URL a la página de venta
    const facebookUrl = "https://facebook.com"; // URL de salida

    // --- COPY ESTRATÉGICO v2 ---

    const resumenVisualClickableHTML = `
    <div class="summary-container">
        <div class="summary-card summary-card-clickable" onclick="mostrarPrecio()">
            <h3>ESTO ES TODO LO QUE RECIBES:</h3>
            <img src="img/LocalWebPro.webp" alt="Paquete LocalWebPro Completo" />
            <ul>
                <li>✅ <strong>Activo Digital de Ventas 24/7</strong> (Tu Página Web Profesional)</li>
                <li>🎁 <strong>Bonus #1:</strong> Tu Mini-Agencia De Marketing Con IA</li>
                <li>🎁 <strong>Bonus #2:</strong> Curso: Domina El Marketing De Tu Negocio</li>
            </ul>
            <div class="value">
                Valor Total Real: <span>$2,647</span> <br>
                <strong>¡Hoy Te Ahorras $2,450!</strong>
            </div>
            <p class="cta-text">TOCA AQUÍ PARA VER LA OFERTA</p>
        </div>
    </div>
    `;

    const resumenVisualFinalHTML = `
    <div class="summary-container">
        <div class="summary-card">
            <h3>LA DECISIÓN ES SIMPLE:</h3>
            <img src="img/LocalWebPro.webp" alt="Paquete LocalWebPro Completo" />
            <p style="text-align: left; margin-top: 10px;">O inviertes en esta <strong>herramienta de crecimiento</strong>, o sigues <strong>regalándole prospectos a tu competencia</strong>. Hoy te llevas:</p>
            <ul>
                <li>✅ <strong>Un Sistema para atraer interesados</strong> (Tu Web Profesional)</li>
                <li>🎁 <strong>+ $747 En Bonos De Regalo</strong> (Mini Agencia De Marketing IA + Curso)</li>
            </ul>
            <div class="value">
                Todo El Paquete Valorado En <strong>$2,647</strong>
            </div>
        </div>
    </div>
    `;

    const mensajesIniciales = [
      "¡Hola de nuevo! Soy Néstor. Vi que te interesó el paquete <strong>LocalWebPro</strong>.",
      "Y es lógico. Sabes que una web profesional ya no es una opción... es la <strong>diferencia entre que un interesado te llame a ti o a tu competencia.</strong>",
      "Pero una web 'bonita' no sirve. Necesitas una herramienta que <strong>trabaje para ti</strong>, que genere confianza y <strong>convierta visitantes en llamadas.</strong>",
      "Por eso, el paquete incluye el sistema completo:<br>✅ Tu <strong>Web Profesional</strong> (el motor de tu negocio)<br>✅ <strong>Dominio .com y Hosting</strong> por 1 año<br>✅ Textos persuasivos y <strong>diseño 100% móvil</strong>",
      "Así se ve la <strong>credibilidad</strong> que proyectan los negocios que ya confiaron en nosotros:",
      "<img src='img/RaudalesEnterprises.webp' loading='lazy' width='100%' alt='Ejemplo Web Raudales Enterprise' />",
      "<img src='img/TrueMoments.webp' loading='lazy' width='100%' alt='Ejemplo Web True Moments' />",
      "<img src='img/TotalRenovations.webp' loading='lazy' width='100%' alt='Ejemplo Web Total Renovations' />",
      "Y para asegurarnos de que tengas resultados, por tiempo limitado, te incluimos <strong>dos aceleradores de negocio:</strong>",
      "<strong>🎁 BONUS GRATIS #1:</strong> Tu Propia <strong>Mini-Agencia de Marketing con IA</strong> (Valorado en $497). Para que nunca te quedes sin ideas para atraer interesados.",
      "<img src='img/MarketingIA-AnunciosPublicitarios.webp' loading='lazy' width='100%' alt='Bonus Herramientas IA' />",
      "<strong>🎁 BONUS GRATIS #2:</strong> Curso <strong>'Domina el Marketing de tu Negocio'</strong> (Valorado en $250). Para que tomes el control y dejes de depender de otros.",
      "<img src='img/Domina-El-Marketing.webp' loading='lazy' width='100%' alt='Bonus Curso de Marketing' />",
      "En resumen, esto es lo que te llevas...",
      resumenVisualClickableHTML
    ];

    const mensajesSalida = [
        "Entiendo. A veces necesitamos pensarlo un poco más.",
        "Pero seamos honestos... ¿cuánto te está costando realmente <strong>no tener una presencia profesional</strong> en línea? Cada persona que busca en Google y no te encuentra, es una <strong>venta perdida.</strong>",
        `<div class='button-box'>
          <a class='button sales-page' href='${salesPageUrl}'>✅ TIENES RAZÓN, QUIERO VER LA OFERTA </a>
          <button class='button facebook' onclick="iniciarUltimoIntento()">❌ AÚN NO ME CONVENZO</button>
        </div>`
    ];
    
    const mensajesUltimoIntento = [
        "Espera. Una última cosa.",
        "La única razón por la que sigues dudando es el <strong>miedo a la inversión</strong>. ¿Verdad? Por eso diseñé la <strong>Oferta de Cero Riesgo.</strong>",
        "<strong>No arriesgas nada.</strong> Inviertes solo <strong>$27</strong> para que construyamos todo el sistema para ti. Si no te encanta el resultado final, <strong>no pagas un centavo más.</strong> El riesgo es <strong>100% nuestro.</strong>",
        resumenVisualFinalHTML,
        `<div class='button-box'>
          <a class='button last-chance' href='${salesPageUrl}'>✅ OK, VOY A INVERTIR EN MI WEB</a>
          <a class='button facebook' href='${facebookUrl}'>❌ NO, PREFIERO SEGUIR PERDIENDO CLIENTES</a>
        </div>`
    ];
    
    // --- FIN DEL COPY ---

    function agregarMensaje(contenido, esHTML = true) {
      const p = document.createElement("div");
      p.className = contenido.includes('summary-container') ? "" : "chat";
      if (esHTML) {
        p.innerHTML = contenido;
      } else {
        p.textContent = contenido;
      }
      chatbox.appendChild(p);
      window.scrollTo(0, document.body.scrollHeight);
    }

    function procesarSecuencia(pasos, i = 0) {
      if (i >= pasos.length) {
        typingIndicator.style.display = "none";
        return;
      }
      
      typingIndicator.style.display = "block";
      window.scrollTo(0, document.body.scrollHeight);
      
      setTimeout(() => {
        typingIndicator.style.display = "none";
        const pasoActual = pasos[i];

        if (pasoActual && pasoActual.tipo === 'audio') {
            const grabando = document.createElement("p");
            grabando.className = "chat";
            grabando.textContent = "Grabando Audio...";
            grabando.id = "grabandoAudio";
            chatbox.appendChild(grabando);
            window.scrollTo(0, document.body.scrollHeight);

            setTimeout(() => {
                const audio = document.createElement("audio");
                audio.controls = true;
                audio.src = "audio.mp3";
                chatbox.appendChild(audio);
                window.scrollTo(0, document.body.scrollHeight);

                const grabandoElemento = document.getElementById("grabandoAudio");
                if (grabandoElemento) grabandoElemento.remove();
                
                procesarSecuencia(pasos, i + 1);
            }, 3000);
        } else if (pasoActual) {
            agregarMensaje(pasoActual);
            procesarSecuencia(pasos, i + 1);
        }
      }, 2500);
    }

    function mostrarPrecio() {
      const clickableCard = document.querySelector(".summary-card-clickable");
      if (clickableCard) {
        clickableCard.style.cursor = 'default';
        clickableCard.onclick = null;
      }
      
      const botonesFinalesHTML = `
        <div class='button-box'>
          <a class='button sales-page' href='${salesPageUrl}'>✅ SÍ, QUIERO MI WEB EN OFERTA</a>
          <button class='button facebook' onclick="iniciarSecuenciaSalida()">❌ NO, AÚN NO ESTOY LISTO</button>
        </div>`;
      
      const pasosDePrecio = [
          "El valor real de todo este paquete es de $2,647. Pero <strong>no vas a pagar eso.</strong>",
          "Ni siquiera la mitad.",
          "<strong>🔥 OFERTA DE CERO RIESGO: Empiezas con solo $27 USD.</strong>",
          "Nosotros construimos todo. Y pagas el resto ($170) <strong>ÚNICAMENTE</strong> si estás <strong>satisfecho</strong> con tu nueva web profesional. Si no, no pagas más. <strong>El riesgo es nuestro.</strong>",
          { tipo: 'audio' },
          botonesFinalesHTML
      ];

      procesarSecuencia(pasosDePrecio);
    }
    
    function iniciarSecuenciaSalida() {
        procesarSecuencia(mensajesSalida);
    }

    function iniciarUltimoIntento() {
        procesarSecuencia(mensajesUltimoIntento);
    }

    document.addEventListener("DOMContentLoaded", function () {
      procesarSecuencia(mensajesIniciales);
    });
</script>

</body>
</html>